/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.tool.Nullable;

public class Sequence
implements Fromable {
    @javax.annotation.Nullable
    private final Database.Schema schema;
    private final String name;
    private final String absoluteName;
    @javax.annotation.Nullable
    private Integer initialValue;
    @javax.annotation.Nullable
    private Integer batchSize;

    public Sequence(String name) {
        this(null, name);
    }

    public Sequence(@javax.annotation.Nullable Database.Schema schema, String name) {
        this.schema = schema;
        if (this.schema != null) {
            this.schema.addSequence(this);
        }
        this.name = name;
        this.absoluteName = (String)Nullable.nullable((Object)schema).map(Database.Schema::getName).map(s -> s + "." + name).getOr((Object)name);
    }

    @javax.annotation.Nullable
    public Database.Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbsoluteName() {
        return this.absoluteName;
    }

    @Override
    public Set<? extends Selectable<?>> getColumns() {
        return Collections.emptySet();
    }

    @Override
    public Map<Selectable<?>, String> getAliases() {
        return Collections.emptyMap();
    }

    @javax.annotation.Nullable
    public Integer getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(@javax.annotation.Nullable Integer initialValue) {
        this.initialValue = initialValue;
    }

    public Sequence withInitialValue(@javax.annotation.Nullable Integer initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    @javax.annotation.Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(@javax.annotation.Nullable Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Sequence withBatchSize(@javax.annotation.Nullable Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }
}

